/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeWrapper
implements IBiomeWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ConcurrentMap<class_6880<class_1959>, BiomeWrapper> WRAPPER_BY_BIOME = new ConcurrentHashMap<class_6880<class_1959>, BiomeWrapper>();
    public static final String EMPTY_STRING = "EMPTY";
    public static final BiomeWrapper EMPTY_WRAPPER = new BiomeWrapper(null, null);
    private static final HashSet<String> BrokenResourceLocationStrings = new HashSet();
    public final class_6880<class_1959> biome;
    private String serialString = null;

    public static IBiomeWrapper getBiomeWrapper(class_6880<class_1959> biome, ILevelWrapper levelWrapper) {
        if (biome == null) {
            return EMPTY_WRAPPER;
        }
        if (WRAPPER_BY_BIOME.containsKey(biome)) {
            return (IBiomeWrapper)WRAPPER_BY_BIOME.get(biome);
        }
        BiomeWrapper newWrapper = new BiomeWrapper(biome, levelWrapper);
        WRAPPER_BY_BIOME.put(biome, newWrapper);
        return newWrapper;
    }

    private BiomeWrapper(class_6880<class_1959> biome, ILevelWrapper levelWrapper) {
        this.biome = biome;
        this.serialString = this.serialize(levelWrapper);
        LOGGER.trace("Created BiomeWrapper [" + this.serialString + "] for [" + biome + "]");
    }

    @Override
    public String getName() {
        if (this == EMPTY_WRAPPER) {
            return EMPTY_STRING;
        }
        return this.biome.method_40230().orElse(class_1972.field_9473).method_41185().toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return Objects.hash(this.getSerialString());
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.biome;
    }

    public String toString() {
        return this.getSerialString();
    }

    public String serialize(ILevelWrapper levelWrapper) {
        if (levelWrapper == null) {
            return EMPTY_STRING;
        }
        if (this.serialString == null) {
            class_5455 registryAccess = class_310.method_1551().field_1687.method_30349();
            class_2960 resourceLocation = registryAccess.method_30530(class_7924.field_41236).method_10221((Object)((class_1959)this.biome.comp_349()));
            if (resourceLocation == null) {
                String biomeName = ((class_1959)this.biome.comp_349()).toString();
                LOGGER.warn("unable to serialize: " + biomeName);
                this.serialString = "";
            } else {
                this.serialString = resourceLocation.method_12836() + ":" + resourceLocation.method_12832();
            }
        }
        return this.serialString;
    }

    public static IBiomeWrapper deserialize(String resourceLocationString, ILevelWrapper levelWrapper) throws IOException {
        if (resourceLocationString.equals(EMPTY_STRING)) {
            LOGGER.warn("[EMPTY] biome string deserialized. This may mean there was a file saving error or a biome saving error.");
            return EMPTY_WRAPPER;
        }
        if (resourceLocationString.trim().isEmpty() || resourceLocationString.equals("")) {
            LOGGER.warn("Null biome string deserialized.");
            return EMPTY_WRAPPER;
        }
        int separatorIndex = resourceLocationString.indexOf(":");
        if (separatorIndex == -1) {
            throw new IOException("Unable to parse resource location string: [" + resourceLocationString + "].");
        }
        class_2960 resourceLocation = new class_2960(resourceLocationString.substring(0, separatorIndex), resourceLocationString.substring(separatorIndex + 1));
        try {
            class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
            class_5455 registryAccess = level.method_30349();
            class_1959 unwrappedBiome = (class_1959)registryAccess.method_30530(class_7924.field_41236).method_10223(resourceLocation);
            boolean success = unwrappedBiome != null;
            class_6880.class_6881 biome = new class_6880.class_6881((Object)unwrappedBiome);
            if (!success) {
                if (!BrokenResourceLocationStrings.contains(resourceLocationString)) {
                    BrokenResourceLocationStrings.add(resourceLocationString);
                    LOGGER.warn("Unable to deserialize biome from string: [" + resourceLocationString + "]");
                }
                return EMPTY_WRAPPER;
            }
            return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)biome, levelWrapper);
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize the string [" + resourceLocationString + "] into a BiomeWrapper: " + e.getMessage(), e);
        }
    }
}

