/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.coreapi.util.math;

import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.nio.FloatBuffer;

public class Mat4f {
    private float m00;
    private float m01;
    private float m02;
    private float m03;
    private float m10;
    private float m11;
    private float m12;
    private float m13;
    private float m20;
    private float m21;
    private float m22;
    private float m23;
    private float m30;
    private float m31;
    private float m32;
    private float m33;

    public Mat4f() {
    }

    public Mat4f(Mat4f sourceMatrix) {
        this.m00 = sourceMatrix.m00;
        this.m01 = sourceMatrix.m01;
        this.m02 = sourceMatrix.m02;
        this.m03 = sourceMatrix.m03;
        this.m10 = sourceMatrix.m10;
        this.m11 = sourceMatrix.m11;
        this.m12 = sourceMatrix.m12;
        this.m13 = sourceMatrix.m13;
        this.m20 = sourceMatrix.m20;
        this.m21 = sourceMatrix.m21;
        this.m22 = sourceMatrix.m22;
        this.m23 = sourceMatrix.m23;
        this.m30 = sourceMatrix.m30;
        this.m31 = sourceMatrix.m31;
        this.m32 = sourceMatrix.m32;
        this.m33 = sourceMatrix.m33;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Mat4f otherMatrix = (Mat4f)obj;
            return Float.compare(otherMatrix.m00, this.m00) == 0 && Float.compare(otherMatrix.m01, this.m01) == 0 && Float.compare(otherMatrix.m02, this.m02) == 0 && Float.compare(otherMatrix.m03, this.m03) == 0 && Float.compare(otherMatrix.m10, this.m10) == 0 && Float.compare(otherMatrix.m11, this.m11) == 0 && Float.compare(otherMatrix.m12, this.m12) == 0 && Float.compare(otherMatrix.m13, this.m13) == 0 && Float.compare(otherMatrix.m20, this.m20) == 0 && Float.compare(otherMatrix.m21, this.m21) == 0 && Float.compare(otherMatrix.m22, this.m22) == 0 && Float.compare(otherMatrix.m23, this.m23) == 0 && Float.compare(otherMatrix.m30, this.m30) == 0 && Float.compare(otherMatrix.m31, this.m31) == 0 && Float.compare(otherMatrix.m32, this.m32) == 0 && Float.compare(otherMatrix.m33, this.m33) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = this.m00 != 0.0f ? Float.floatToIntBits(this.m00) : 0;
        i = 31 * i + (this.m01 != 0.0f ? Float.floatToIntBits(this.m01) : 0);
        i = 31 * i + (this.m02 != 0.0f ? Float.floatToIntBits(this.m02) : 0);
        i = 31 * i + (this.m03 != 0.0f ? Float.floatToIntBits(this.m03) : 0);
        i = 31 * i + (this.m10 != 0.0f ? Float.floatToIntBits(this.m10) : 0);
        i = 31 * i + (this.m11 != 0.0f ? Float.floatToIntBits(this.m11) : 0);
        i = 31 * i + (this.m12 != 0.0f ? Float.floatToIntBits(this.m12) : 0);
        i = 31 * i + (this.m13 != 0.0f ? Float.floatToIntBits(this.m13) : 0);
        i = 31 * i + (this.m20 != 0.0f ? Float.floatToIntBits(this.m20) : 0);
        i = 31 * i + (this.m21 != 0.0f ? Float.floatToIntBits(this.m21) : 0);
        i = 31 * i + (this.m22 != 0.0f ? Float.floatToIntBits(this.m22) : 0);
        i = 31 * i + (this.m23 != 0.0f ? Float.floatToIntBits(this.m23) : 0);
        i = 31 * i + (this.m30 != 0.0f ? Float.floatToIntBits(this.m30) : 0);
        i = 31 * i + (this.m31 != 0.0f ? Float.floatToIntBits(this.m31) : 0);
        i = 31 * i + (this.m32 != 0.0f ? Float.floatToIntBits(this.m32) : 0);
        return 31 * i + (this.m33 != 0.0f ? Float.floatToIntBits(this.m33) : 0);
    }

    public String toString() {
        return "Matrix4f:\n" + this.m00 + " " + this.m01 + " " + this.m02 + " " + this.m03 + "\n" + this.m10 + " " + this.m11 + " " + this.m12 + " " + this.m13 + "\n" + this.m20 + " " + this.m21 + " " + this.m22 + " " + this.m23 + "\n" + this.m30 + " " + this.m31 + " " + this.m32 + " " + this.m33 + "\n";
    }

    public void store(FloatBuffer floatBuffer) {
        floatBuffer.put(Mat4f.bufferIndex(0, 0), this.m00);
        floatBuffer.put(Mat4f.bufferIndex(0, 1), this.m01);
        floatBuffer.put(Mat4f.bufferIndex(0, 2), this.m02);
        floatBuffer.put(Mat4f.bufferIndex(0, 3), this.m03);
        floatBuffer.put(Mat4f.bufferIndex(1, 0), this.m10);
        floatBuffer.put(Mat4f.bufferIndex(1, 1), this.m11);
        floatBuffer.put(Mat4f.bufferIndex(1, 2), this.m12);
        floatBuffer.put(Mat4f.bufferIndex(1, 3), this.m13);
        floatBuffer.put(Mat4f.bufferIndex(2, 0), this.m20);
        floatBuffer.put(Mat4f.bufferIndex(2, 1), this.m21);
        floatBuffer.put(Mat4f.bufferIndex(2, 2), this.m22);
        floatBuffer.put(Mat4f.bufferIndex(2, 3), this.m23);
        floatBuffer.put(Mat4f.bufferIndex(3, 0), this.m30);
        floatBuffer.put(Mat4f.bufferIndex(3, 1), this.m31);
        floatBuffer.put(Mat4f.bufferIndex(3, 2), this.m32);
        floatBuffer.put(Mat4f.bufferIndex(3, 3), this.m33);
    }

    private static int bufferIndex(int xIndex, int zIndex) {
        return zIndex * 4 + xIndex;
    }

    public void setIdentity() {
        this.m00 = 1.0f;
        this.m01 = 0.0f;
        this.m02 = 0.0f;
        this.m03 = 0.0f;
        this.m10 = 0.0f;
        this.m11 = 1.0f;
        this.m12 = 0.0f;
        this.m13 = 0.0f;
        this.m20 = 0.0f;
        this.m21 = 0.0f;
        this.m22 = 1.0f;
        this.m23 = 0.0f;
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
    }

    public float adjudicateAndDet() {
        float f = this.m00 * this.m11 - this.m01 * this.m10;
        float f1 = this.m00 * this.m12 - this.m02 * this.m10;
        float f2 = this.m00 * this.m13 - this.m03 * this.m10;
        float f3 = this.m01 * this.m12 - this.m02 * this.m11;
        float f4 = this.m01 * this.m13 - this.m03 * this.m11;
        float f5 = this.m02 * this.m13 - this.m03 * this.m12;
        float f6 = this.m20 * this.m31 - this.m21 * this.m30;
        float f7 = this.m20 * this.m32 - this.m22 * this.m30;
        float f8 = this.m20 * this.m33 - this.m23 * this.m30;
        float f9 = this.m21 * this.m32 - this.m22 * this.m31;
        float f10 = this.m21 * this.m33 - this.m23 * this.m31;
        float f11 = this.m22 * this.m33 - this.m23 * this.m32;
        float f12 = this.m11 * f11 - this.m12 * f10 + this.m13 * f9;
        float f13 = -this.m10 * f11 + this.m12 * f8 - this.m13 * f7;
        float f14 = this.m10 * f10 - this.m11 * f8 + this.m13 * f6;
        float f15 = -this.m10 * f9 + this.m11 * f7 - this.m12 * f6;
        float f16 = -this.m01 * f11 + this.m02 * f10 - this.m03 * f9;
        float f17 = this.m00 * f11 - this.m02 * f8 + this.m03 * f7;
        float f18 = -this.m00 * f10 + this.m01 * f8 - this.m03 * f6;
        float f19 = this.m00 * f9 - this.m01 * f7 + this.m02 * f6;
        float f20 = this.m31 * f5 - this.m32 * f4 + this.m33 * f3;
        float f21 = -this.m30 * f5 + this.m32 * f2 - this.m33 * f1;
        float f22 = this.m30 * f4 - this.m31 * f2 + this.m33 * f;
        float f23 = -this.m30 * f3 + this.m31 * f1 - this.m32 * f;
        float f24 = -this.m21 * f5 + this.m22 * f4 - this.m23 * f3;
        float f25 = this.m20 * f5 - this.m22 * f2 + this.m23 * f1;
        float f26 = -this.m20 * f4 + this.m21 * f2 - this.m23 * f;
        float f27 = this.m20 * f3 - this.m21 * f1 + this.m22 * f;
        this.m00 = f12;
        this.m10 = f13;
        this.m20 = f14;
        this.m30 = f15;
        this.m01 = f16;
        this.m11 = f17;
        this.m21 = f18;
        this.m31 = f19;
        this.m02 = f20;
        this.m12 = f21;
        this.m22 = f22;
        this.m32 = f23;
        this.m03 = f24;
        this.m13 = f25;
        this.m23 = f26;
        this.m33 = f27;
        return f * f11 - f1 * f10 + f2 * f9 + f3 * f8 - f4 * f7 + f5 * f6;
    }

    public void transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        f = this.m30;
        this.m30 = this.m03;
        this.m03 = f;
        f = this.m31;
        this.m31 = this.m13;
        this.m13 = f;
        f = this.m32;
        this.m32 = this.m23;
        this.m23 = f;
    }

    public boolean canInvert() {
        float det = this.adjudicateAndDet();
        return Math.abs(det) > 1.0E-6f;
    }

    public void invert() {
        float det = this.adjudicateAndDet();
        if (Math.abs(det) > 1.0E-6f) {
            this.multiply(det);
        }
    }

    public void multiply(Mat4f multMatrix) {
        float f = this.m00 * multMatrix.m00 + this.m01 * multMatrix.m10 + this.m02 * multMatrix.m20 + this.m03 * multMatrix.m30;
        float f1 = this.m00 * multMatrix.m01 + this.m01 * multMatrix.m11 + this.m02 * multMatrix.m21 + this.m03 * multMatrix.m31;
        float f2 = this.m00 * multMatrix.m02 + this.m01 * multMatrix.m12 + this.m02 * multMatrix.m22 + this.m03 * multMatrix.m32;
        float f3 = this.m00 * multMatrix.m03 + this.m01 * multMatrix.m13 + this.m02 * multMatrix.m23 + this.m03 * multMatrix.m33;
        float f4 = this.m10 * multMatrix.m00 + this.m11 * multMatrix.m10 + this.m12 * multMatrix.m20 + this.m13 * multMatrix.m30;
        float f5 = this.m10 * multMatrix.m01 + this.m11 * multMatrix.m11 + this.m12 * multMatrix.m21 + this.m13 * multMatrix.m31;
        float f6 = this.m10 * multMatrix.m02 + this.m11 * multMatrix.m12 + this.m12 * multMatrix.m22 + this.m13 * multMatrix.m32;
        float f7 = this.m10 * multMatrix.m03 + this.m11 * multMatrix.m13 + this.m12 * multMatrix.m23 + this.m13 * multMatrix.m33;
        float f8 = this.m20 * multMatrix.m00 + this.m21 * multMatrix.m10 + this.m22 * multMatrix.m20 + this.m23 * multMatrix.m30;
        float f9 = this.m20 * multMatrix.m01 + this.m21 * multMatrix.m11 + this.m22 * multMatrix.m21 + this.m23 * multMatrix.m31;
        float f10 = this.m20 * multMatrix.m02 + this.m21 * multMatrix.m12 + this.m22 * multMatrix.m22 + this.m23 * multMatrix.m32;
        float f11 = this.m20 * multMatrix.m03 + this.m21 * multMatrix.m13 + this.m22 * multMatrix.m23 + this.m23 * multMatrix.m33;
        float f12 = this.m30 * multMatrix.m00 + this.m31 * multMatrix.m10 + this.m32 * multMatrix.m20 + this.m33 * multMatrix.m30;
        float f13 = this.m30 * multMatrix.m01 + this.m31 * multMatrix.m11 + this.m32 * multMatrix.m21 + this.m33 * multMatrix.m31;
        float f14 = this.m30 * multMatrix.m02 + this.m31 * multMatrix.m12 + this.m32 * multMatrix.m22 + this.m33 * multMatrix.m32;
        float f15 = this.m30 * multMatrix.m03 + this.m31 * multMatrix.m13 + this.m32 * multMatrix.m23 + this.m33 * multMatrix.m33;
        this.m00 = f;
        this.m01 = f1;
        this.m02 = f2;
        this.m03 = f3;
        this.m10 = f4;
        this.m11 = f5;
        this.m12 = f6;
        this.m13 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
        this.m23 = f11;
        this.m30 = f12;
        this.m31 = f13;
        this.m32 = f14;
        this.m33 = f15;
    }

    public void multiply(float scalar) {
        this.m00 *= scalar;
        this.m01 *= scalar;
        this.m02 *= scalar;
        this.m03 *= scalar;
        this.m10 *= scalar;
        this.m11 *= scalar;
        this.m12 *= scalar;
        this.m13 *= scalar;
        this.m20 *= scalar;
        this.m21 *= scalar;
        this.m22 *= scalar;
        this.m23 *= scalar;
        this.m30 *= scalar;
        this.m31 *= scalar;
        this.m32 *= scalar;
        this.m33 *= scalar;
    }

    public static Mat4f perspective(double fov, float widthHeightRatio, float nearClipPlane, float farClipPlane) {
        float f = (float)(1.0 / Math.tan(fov * 0.01745329238474369 / 2.0));
        Mat4f matrix = new Mat4f();
        matrix.m00 = f / widthHeightRatio;
        matrix.m11 = f;
        matrix.m22 = (farClipPlane + nearClipPlane) / (nearClipPlane - farClipPlane);
        matrix.m32 = -1.0f;
        matrix.m23 = 2.0f * farClipPlane * nearClipPlane / (nearClipPlane - farClipPlane);
        return matrix;
    }

    public void translate(Vec3f vec) {
        this.m03 += vec.x;
        this.m13 += vec.y;
        this.m23 += vec.z;
    }

    public void multiplyTranslationMatrix(double x, double y, double z) {
        this.multiply(Mat4f.createTranslateMatrix((float)x, (float)y, (float)z));
    }

    public Mat4f copy() {
        return new Mat4f(this);
    }

    public static Mat4f createScaleMatrix(float x, float y, float z) {
        Mat4f matrix = new Mat4f();
        matrix.m00 = x;
        matrix.m11 = y;
        matrix.m22 = z;
        matrix.m33 = 1.0f;
        return matrix;
    }

    public static Mat4f createTranslateMatrix(float x, float y, float z) {
        Mat4f matrix = new Mat4f();
        matrix.m00 = 1.0f;
        matrix.m11 = 1.0f;
        matrix.m22 = 1.0f;
        matrix.m33 = 1.0f;
        matrix.m03 = x;
        matrix.m13 = y;
        matrix.m23 = z;
        return matrix;
    }

    public float[] getValuesAsArray() {
        return new float[]{this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33};
    }

    public Vec3f asNonNormalizedLookForwardVector() {
        return new Vec3f(this.m02, this.m12, this.m22);
    }

    public Mat4f(float[] values) {
        this.m00 = values[0];
        this.m01 = values[1];
        this.m02 = values[2];
        this.m03 = values[3];
        this.m10 = values[4];
        this.m11 = values[5];
        this.m12 = values[6];
        this.m13 = values[7];
        this.m20 = values[8];
        this.m21 = values[9];
        this.m22 = values[10];
        this.m23 = values[11];
        this.m30 = values[12];
        this.m31 = values[13];
        this.m32 = values[14];
        this.m33 = values[15];
    }

    public Mat4f(FloatBuffer buffer) {
        this(buffer.array());
    }

    public void set(Mat4f mat) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;
        this.m03 = mat.m03;
        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;
        this.m13 = mat.m13;
        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
        this.m23 = mat.m23;
        this.m30 = mat.m30;
        this.m31 = mat.m31;
        this.m32 = mat.m32;
        this.m33 = mat.m33;
    }

    public void add(Mat4f other) {
        this.m00 += other.m00;
        this.m01 += other.m01;
        this.m02 += other.m02;
        this.m03 += other.m03;
        this.m10 += other.m10;
        this.m11 += other.m11;
        this.m12 += other.m12;
        this.m13 += other.m13;
        this.m20 += other.m20;
        this.m21 += other.m21;
        this.m22 += other.m22;
        this.m23 += other.m23;
        this.m30 += other.m30;
        this.m31 += other.m31;
        this.m32 += other.m32;
        this.m33 += other.m33;
    }

    public void multiplyBackward(Mat4f other) {
        Mat4f copy = other.copy();
        copy.multiply(this);
        this.set(copy);
    }

    public void setTranslation(float x, float y, float z) {
        this.m00 = 1.0f;
        this.m11 = 1.0f;
        this.m22 = 1.0f;
        this.m33 = 1.0f;
        this.m03 = x;
        this.m13 = y;
        this.m23 = z;
    }

    public void setClipPlanes(float nearClip, float farClip) {
        float matNearClip = -((farClip + nearClip) / (farClip - nearClip));
        float matFarClip = -(2.0f * farClip * nearClip / (farClip - nearClip));
        this.m22 = matNearClip;
        this.m23 = matFarClip;
    }
}

