/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.texture;

import com.seibel.distanthorizons.core.render.glObject.texture.EDhDepthBufferFormat;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.lwjgl.opengl.GL32;

public class DhFramebuffer {
    private final Int2IntMap attachments;
    private final int maxDrawBuffers;
    private final int maxColorAttachments;
    private boolean hasDepthAttachment;
    private int id;

    public DhFramebuffer() {
        this.id = GL32.glGenFramebuffers();
        this.attachments = new Int2IntArrayMap();
        this.maxDrawBuffers = GL32.glGetInteger((int)34852);
        this.maxColorAttachments = GL32.glGetInteger((int)36063);
        this.hasDepthAttachment = false;
    }

    public DhFramebuffer(int id) {
        this.id = id;
        this.attachments = new Int2IntArrayMap();
        this.maxDrawBuffers = GL32.glGetInteger((int)34852);
        this.maxColorAttachments = GL32.glGetInteger((int)36063);
        this.hasDepthAttachment = false;
    }

    public void addDepthAttachment(int texture, EDhDepthBufferFormat depthBufferFormat) {
        this.bind();
        if (depthBufferFormat.isCombinedStencil()) {
            GL32.glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)texture, (int)0);
        } else {
            GL32.glFramebufferTexture2D((int)36160, (int)36096, (int)3553, (int)texture, (int)0);
        }
        this.hasDepthAttachment = true;
    }

    public void addColorAttachment(int index, int texture) {
        int fb = this.id;
        this.bind();
        GL32.glFramebufferTexture2D((int)36160, (int)(36064 + index), (int)3553, (int)texture, (int)0);
        this.attachments.put(index, texture);
    }

    public void noDrawBuffers() {
        this.bind();
        GL32.glDrawBuffers((int[])new int[]{0});
    }

    public void drawBuffers(int[] buffers) {
        int[] glBuffers = new int[buffers.length];
        int index = 0;
        if (buffers.length > this.maxDrawBuffers) {
            throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
        }
        for (int buffer : buffers) {
            if (buffer >= this.maxColorAttachments) {
                throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + buffer);
            }
            glBuffers[index++] = 36064 + buffer;
        }
        this.bind();
        GL32.glDrawBuffers((int[])new int[]{0});
    }

    public void readBuffer(int buffer) {
        this.bind();
        GL32.glReadBuffer((int)(36064 + buffer));
    }

    public int getColorAttachment(int index) {
        return this.attachments.get(index);
    }

    public boolean hasDepthAttachment() {
        return this.hasDepthAttachment;
    }

    public void bind() {
        if (this.id == -1) {
            throw new IllegalStateException("Framebuffer does not exist!");
        }
        GL32.glBindFramebuffer((int)36160, (int)this.id);
    }

    public void bindAsReadBuffer() {
        GL32.glBindFramebuffer((int)36008, (int)this.id);
    }

    public void bindAsDrawBuffer() {
        GL32.glBindFramebuffer((int)36009, (int)this.id);
    }

    public void destroyInternal() {
        GL32.glDeleteFramebuffers((int)this.id);
        this.id = -1;
    }

    public int getStatus() {
        this.bind();
        int status = GL32.glCheckFramebufferStatus((int)36160);
        return status;
    }

    public int getId() {
        return this.id;
    }
}

