/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.render.AbstractRenderBuffer;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.objects.SortedArraySet;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class RenderBufferHandler {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final LodQuadTree lodQuadTree;
    private SortedArraySet<LoadedRenderBuffer> loadedNearToFarBuffers = null;
    private final AtomicBoolean rebuildAllBuffers = new AtomicBoolean(false);

    public RenderBufferHandler(LodQuadTree lodQuadTree) {
        this.lodQuadTree = lodQuadTree;
    }

    public void buildRenderListAndUpdateSections(Vec3f lookForwardVector) {
        EDhDirection zDir;
        EDhDirection[] axisDirections = new EDhDirection[3];
        float absX = Math.abs(lookForwardVector.x);
        float absY = Math.abs(lookForwardVector.y);
        float absZ = Math.abs(lookForwardVector.z);
        EDhDirection xDir = lookForwardVector.x < 0.0f ? EDhDirection.EAST : EDhDirection.WEST;
        EDhDirection yDir = lookForwardVector.y < 0.0f ? EDhDirection.UP : EDhDirection.DOWN;
        EDhDirection eDhDirection = zDir = lookForwardVector.z < 0.0f ? EDhDirection.SOUTH : EDhDirection.NORTH;
        if (absX >= absY && absX >= absZ) {
            axisDirections[0] = xDir;
            if (absY >= absZ) {
                axisDirections[1] = yDir;
                axisDirections[2] = zDir;
            } else {
                axisDirections[1] = zDir;
                axisDirections[2] = yDir;
            }
        } else if (absY >= absX && absY >= absZ) {
            axisDirections[0] = yDir;
            if (absX >= absZ) {
                axisDirections[1] = xDir;
                axisDirections[2] = zDir;
            } else {
                axisDirections[1] = zDir;
                axisDirections[2] = xDir;
            }
        } else {
            axisDirections[0] = zDir;
            if (absX >= absY) {
                axisDirections[1] = xDir;
                axisDirections[2] = yDir;
            } else {
                axisDirections[1] = yDir;
                axisDirections[2] = xDir;
            }
        }
        Pos2D cPos = this.lodQuadTree.getCenterBlockPos().toPos2D();
        Comparator farToNearComparator = (loadedBufferA, loadedBufferB) -> {
            Pos2D aPos = loadedBufferA.pos.getCenterBlockPos().toPos2D();
            Pos2D bPos = loadedBufferB.pos.getCenterBlockPos().toPos2D();
            int aManhattanDistance = aPos.manhattanDist(cPos);
            int bManhattanDistance = bPos.manhattanDist(cPos);
            return bManhattanDistance - aManhattanDistance;
        };
        this.loadedNearToFarBuffers = new SortedArraySet((a, b) -> -farToNearComparator.compare(a, b));
        boolean rebuildAllBuffers = this.rebuildAllBuffers.getAndSet(false);
        Iterator nodeIterator = this.lodQuadTree.nodeIterator();
        while (nodeIterator.hasNext()) {
            QuadNode node = nodeIterator.next();
            DhSectionPos sectionPos = node.sectionPos;
            LodRenderSection renderSection = (LodRenderSection)node.value;
            try {
                AbstractRenderBuffer buffer;
                if (renderSection == null) continue;
                if (rebuildAllBuffers) {
                    renderSection.markBufferDirty();
                }
                renderSection.tryBuildAndSwapBuffer();
                if (!renderSection.isRenderingEnabled() || (buffer = (AbstractRenderBuffer)renderSection.activeRenderBufferRef.get()) == null) continue;
                this.loadedNearToFarBuffers.add(new LoadedRenderBuffer(buffer, sectionPos));
            }
            catch (Exception e) {
                LOGGER.error("Error updating QuadTree render source at " + renderSection.pos + ".", (Throwable)e);
                renderSection.markBufferDirty();
            }
        }
    }

    public void renderOpaque(LodRenderer renderContext) {
        this.loadedNearToFarBuffers.forEach(loadedBuffer -> loadedBuffer.buffer.renderOpaque(renderContext));
    }

    public void renderTransparent(LodRenderer renderContext) {
        ListIterator<LoadedRenderBuffer> iter = this.loadedNearToFarBuffers.listIterator(this.loadedNearToFarBuffers.size());
        while (iter.hasPrevious()) {
            LoadedRenderBuffer loadedBuffer = iter.previous();
            loadedBuffer.buffer.renderTransparent(renderContext);
        }
    }

    public void MarkAllBuffersDirty() {
        this.rebuildAllBuffers.set(true);
    }

    public void close() {
        Iterator nodeIterator = this.lodQuadTree.nodeIterator();
        while (nodeIterator.hasNext()) {
            LodRenderSection renderSection = (LodRenderSection)nodeIterator.next().value;
            if (renderSection == null) continue;
            renderSection.dispose();
        }
    }

    private static class LoadedRenderBuffer {
        public final AbstractRenderBuffer buffer;
        public final DhSectionPos pos;

        LoadedRenderBuffer(AbstractRenderBuffer buffer, DhSectionPos pos) {
            this.buffer = buffer;
            this.pos = pos;
        }
    }
}

