/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.api.enums.config.EHorizontalQuality;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.core.file.renderfile.IRenderSourceProvider;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadTree;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public class LodQuadTree
extends QuadTree<LodRenderSection>
implements AutoCloseable {
    public static final byte TREE_LOWEST_DETAIL_LEVEL = 6;
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final int blockRenderDistanceDiameter;
    private final IRenderSourceProvider renderSourceProvider;
    private final ConcurrentLinkedQueue<DhSectionPos> sectionsToReload = new ConcurrentLinkedQueue();
    private final IDhClientLevel level;
    private final ConfigChangeListener<EHorizontalQuality> horizontalScaleChangeListener;
    private final ReentrantLock treeReadWriteLock = new ReentrantLock();
    private byte maxRenderDetailLevel;
    private byte minRenderDetailLevel;
    private double detailDropOffDistanceUnit;
    private double detailDropOffLogBase;

    public LodQuadTree(IDhClientLevel level, int viewDiameterInBlocks, int initialPlayerBlockX, int initialPlayerBlockZ, IRenderSourceProvider provider) {
        super(viewDiameterInBlocks, new DhBlockPos2D(initialPlayerBlockX, initialPlayerBlockZ), (byte)6);
        this.level = level;
        this.renderSourceProvider = provider;
        this.blockRenderDistanceDiameter = viewDiameterInBlocks;
        this.horizontalScaleChangeListener = new ConfigChangeListener<EHorizontalQuality>(Config.Client.Advanced.Graphics.Quality.horizontalQuality, newHorizontalScale -> this.onHorizontalQualityChange());
    }

    public void tick(DhBlockPos2D playerPos) {
        if (this.level == null) {
            return;
        }
        this.updateDetailLevelVariables();
        if (this.treeReadWriteLock.tryLock()) {
            try {
                this.setCenterBlockPos(playerPos, LodRenderSection::dispose);
                this.updateAllRenderSections(playerPos);
            }
            catch (Exception e) {
                LOGGER.error("Quad Tree tick exception for dimension: " + this.level.getClientLevelWrapper().getDimensionType().getDimensionName() + ", exception: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.treeReadWriteLock.unlock();
            }
        }
    }

    private void updateAllRenderSections(DhBlockPos2D playerPos) {
        DhSectionPos pos;
        while ((pos = this.sectionsToReload.poll()) != null) {
            while (pos.getDetailLevel() <= this.treeMinDetailLevel) {
                try {
                    LodRenderSection renderSection = (LodRenderSection)this.getValue(pos);
                    if (renderSection != null) {
                        renderSection.reload(this.renderSourceProvider);
                    }
                }
                catch (IndexOutOfBoundsException renderSection) {
                    // empty catch block
                }
                pos = pos.getParentPos();
            }
        }
        Iterator<DhSectionPos> rootPosIterator = this.rootNodePosIterator();
        while (rootPosIterator.hasNext()) {
            DhSectionPos rootPos = rootPosIterator.next();
            if (this.getNode(rootPos) == null) {
                this.setValue(rootPos, new LodRenderSection(this, rootPos));
            }
            QuadNode<LodRenderSection> rootNode = this.getNode(rootPos);
            this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, rootNode, rootNode.sectionPos, false);
        }
    }

    private boolean recursivelyUpdateRenderSectionNode(DhBlockPos2D playerPos, QuadNode<LodRenderSection> rootNode, QuadNode<LodRenderSection> quadNode, DhSectionPos sectionPos, boolean parentRenderSectionIsEnabled) {
        if (quadNode == null && this.isSectionPosInBounds(sectionPos)) {
            rootNode.setValue(sectionPos, new LodRenderSection(this, sectionPos));
            quadNode = rootNode.getNode(sectionPos);
        }
        if (quadNode == null) {
            return false;
        }
        LodRenderSection renderSection = (LodRenderSection)quadNode.value;
        if (renderSection == null) {
            LodRenderSection newRenderSection = new LodRenderSection(this, sectionPos);
            rootNode.setValue(sectionPos, newRenderSection);
            renderSection = newRenderSection;
        }
        byte expectedDetailLevel = this.calculateExpectedDetailLevel(playerPos, sectionPos);
        expectedDetailLevel = (byte)Math.min(expectedDetailLevel, this.minRenderDetailLevel);
        expectedDetailLevel = (byte)(expectedDetailLevel + 6);
        if (sectionPos.getDetailLevel() > expectedDetailLevel) {
            boolean childSectionLoaded;
            QuadNode<LodRenderSection> childNode;
            DhSectionPos childPos;
            boolean canThisPosRender = renderSection.isRenderingEnabled();
            boolean allChildrenSectionsAreLoaded = true;
            Iterator<DhSectionPos> childPosIterator = quadNode.getChildPosIterator();
            while (childPosIterator.hasNext()) {
                childPos = childPosIterator.next();
                childNode = rootNode.getNode(childPos);
                childSectionLoaded = this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, childPos, canThisPosRender || parentRenderSectionIsEnabled);
                allChildrenSectionsAreLoaded = childSectionLoaded && allChildrenSectionsAreLoaded;
            }
            if (!allChildrenSectionsAreLoaded) {
                return canThisPosRender;
            }
            renderSection.disableRendering();
            renderSection.disposeRenderData();
            childPosIterator = quadNode.getChildPosIterator();
            while (childPosIterator.hasNext()) {
                childPos = childPosIterator.next();
                childNode = rootNode.getNode(childPos);
                childSectionLoaded = this.recursivelyUpdateRenderSectionNode(playerPos, rootNode, childNode, childPos, parentRenderSectionIsEnabled);
                allChildrenSectionsAreLoaded = childSectionLoaded && allChildrenSectionsAreLoaded;
            }
            if (!allChildrenSectionsAreLoaded) {
                // empty if block
            }
            return true;
        }
        if (sectionPos.getDetailLevel() == expectedDetailLevel || sectionPos.getDetailLevel() == expectedDetailLevel - 1) {
            renderSection.loadRenderSource(this.renderSourceProvider, this.level);
            if (!parentRenderSectionIsEnabled && renderSection.canRenderNow() && !renderSection.isRenderingEnabled()) {
                renderSection.enableRendering();
                quadNode.deleteAllChildren(childRenderSection -> {
                    if (childRenderSection != null) {
                        childRenderSection.disableRendering();
                        childRenderSection.disposeRenderData();
                    }
                });
            }
            return renderSection.canRenderNow();
        }
        throw new IllegalStateException("LodQuadTree shouldn't be updating renderSections below the expected detail level: [" + expectedDetailLevel + "].");
    }

    public byte calculateExpectedDetailLevel(DhBlockPos2D playerPos, DhSectionPos sectionPos) {
        return this.getDetailLevelFromDistance(playerPos.dist(sectionPos.getCenterBlockPosX(), sectionPos.getCenterBlockPosZ()));
    }

    private byte getDetailLevelFromDistance(double distance) {
        if (Config.Client.Advanced.Graphics.Quality.horizontalQuality.get() == EHorizontalQuality.UNLIMITED) {
            return this.maxRenderDetailLevel;
        }
        double maxDetailDistance = this.getDrawDistanceFromDetail(126);
        if (distance > maxDetailDistance) {
            return 126;
        }
        int detailLevel = (int)(Math.log(distance / this.detailDropOffDistanceUnit) / this.detailDropOffLogBase);
        return (byte)MathUtil.clamp(this.maxRenderDetailLevel, detailLevel, 126);
    }

    private double getDrawDistanceFromDetail(int detail) {
        if (detail <= this.maxRenderDetailLevel) {
            return 0.0;
        }
        if (detail >= 127) {
            return this.blockRenderDistanceDiameter * 2;
        }
        double base = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase;
        return Math.pow(base, detail) * this.detailDropOffDistanceUnit;
    }

    private void updateDetailLevelVariables() {
        this.detailDropOffDistanceUnit = Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().distanceUnitInBlocks * 16;
        this.detailDropOffLogBase = Math.log(Config.Client.Advanced.Graphics.Quality.horizontalQuality.get().quadraticBase);
        this.maxRenderDetailLevel = Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution.get().detailLevel;
        byte minSectionDetailLevel = this.getDetailLevelFromDistance(this.blockRenderDistanceDiameter);
        minSectionDetailLevel = (byte)(minSectionDetailLevel - 1);
        minSectionDetailLevel = (byte)Math.min(minSectionDetailLevel, this.treeMinDetailLevel);
        this.minRenderDetailLevel = (byte)Math.max(minSectionDetailLevel, this.maxRenderDetailLevel);
    }

    public void clearRenderDataCache() {
        if (this.treeReadWriteLock.tryLock()) {
            try {
                LOGGER.info("Clearing render cache...");
                Iterator nodeIterator = this.nodeIterator();
                while (nodeIterator.hasNext()) {
                    QuadNode quadNode = nodeIterator.next();
                    if (quadNode.value == null) continue;
                    ((LodRenderSection)quadNode.value).disposeRenderData();
                    quadNode.value = null;
                }
                this.renderSourceProvider.deleteRenderCache();
                LOGGER.info("Render cache invalidated, please wait a moment for everything to reload...");
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error when clearing LodQuadTree render cache: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.treeReadWriteLock.unlock();
            }
        }
    }

    public void reloadPos(DhSectionPos pos) {
        if (pos == null) {
            LOGGER.warn("reloadPos given a null pos.");
            return;
        }
        this.sectionsToReload.add(pos);
    }

    private void onHorizontalQualityChange() {
        this.clearRenderDataCache();
    }

    @Override
    public void close() {
        LOGGER.info("Shutting down " + LodQuadTree.class.getSimpleName() + "...");
        this.horizontalScaleChangeListener.close();
        Iterator nodeIterator = this.nodeIterator();
        while (nodeIterator.hasNext()) {
            QuadNode quadNode = nodeIterator.next();
            if (quadNode.value == null) continue;
            ((LodRenderSection)quadNode.value).dispose();
            quadNode.value = null;
        }
        LOGGER.info("Finished shutting down " + LodQuadTree.class.getSimpleName());
    }
}

