/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.IFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.DhLevel;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhServerLevel;
import com.seibel.distanthorizons.core.level.ServerLevelModule;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import java.awt.Color;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;

public class DhClientServerLevel
extends DhLevel
implements IDhClientLevel,
IDhServerLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final ServerLevelModule serverside;
    public final ClientLevelModule clientside;
    private final IServerLevelWrapper serverLevelWrapper;

    public DhClientServerLevel(AbstractSaveStructure saveStructure, IServerLevelWrapper serverLevelWrapper) {
        if (saveStructure.getFullDataFolder(serverLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.");
        }
        this.serverLevelWrapper = serverLevelWrapper;
        this.serverside = new ServerLevelModule(this, saveStructure);
        this.clientside = new ClientLevelModule(this);
        LOGGER.info("Started " + DhClientServerLevel.class.getSimpleName() + " for " + serverLevelWrapper + " with saves at " + saveStructure);
    }

    @Override
    public void clientTick() {
        this.clientside.clientTick();
    }

    @Override
    public void render(Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        this.clientside.render(mcModelViewMatrix, mcProjectionMatrix, partialTicks, profiler);
    }

    @Override
    public void serverTick() {
        this.chunkToLodBuilder.tick();
    }

    @Override
    public void doWorldGen() {
        this.serverside.worldGeneratorEnabledConfig.pollNewValue();
        boolean shouldDoWorldGen = this.serverside.worldGeneratorEnabledConfig.get() != false && this.clientside.isRendering();
        boolean isWorldGenRunning = this.serverside.worldGenModule.isWorldGenRunning();
        if (shouldDoWorldGen && !isWorldGenRunning) {
            this.serverside.worldGenModule.startWorldGen(this.serverside.dataFileHandler, new ServerLevelModule.WorldGenState(this));
        } else if (!shouldDoWorldGen && isWorldGenRunning) {
            this.serverside.worldGenModule.stopWorldGen(this.serverside.dataFileHandler);
        }
        if (this.serverside.worldGenModule.isWorldGenRunning()) {
            ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
            if (renderState != null && renderState.quadtree != null) {
                this.serverside.dataFileHandler.removeGenRequestIf(pos -> !renderState.quadtree.isSectionPosInBounds((DhSectionPos)pos));
            }
            this.serverside.worldGenModule.worldGenTick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
        }
    }

    public void startRenderer(IClientLevelWrapper clientLevel) {
        this.clientside.startRenderer(clientLevel);
    }

    public void stopRenderer() {
        this.clientside.stopRenderer();
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        IClientLevelWrapper clientLevel = this.getClientLevelWrapper();
        if (clientLevel == null) {
            return 0;
        }
        return clientLevel.computeBaseColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return this.serverLevelWrapper.tryGetClientLevelWrapper();
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public IServerLevelWrapper getServerLevelWrapper() {
        return this.serverLevelWrapper;
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.getServerLevelWrapper();
    }

    @Override
    public IFullDataSourceProvider getFileHandler() {
        return this.serverside.dataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.serverside.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.serverLevelWrapper.hasSkyLight();
    }

    @Override
    public void saveWrites(ChunkSizedFullDataAccessor data) {
        this.clientside.writeChunkDataToFile(data);
    }

    @Override
    public int getMinY() {
        return this.getLevelWrapper().getMinHeight();
    }

    @Override
    public CompletableFuture<Void> saveAsync() {
        return CompletableFuture.allOf(this.clientside.saveAsync(), this.getFileHandler().flushAndSaveAsync());
    }

    @Override
    public void close() {
        this.clientside.close();
        super.close();
        this.serverside.close();
        LOGGER.info("Closed " + this.getClass().getSimpleName() + " for " + this.getServerLevelWrapper());
    }

    @Override
    public void onWorldGenTaskComplete(DhSectionPos pos) {
        DebugRenderer.makeParticle(new DebugRenderer.BoxParticle(new DebugRenderer.Box(pos, 128.0f, 156.0f, 0.09f, Color.red.darker()), 0.2, 32.0f));
        this.clientside.reloadPos(pos);
    }
}

