/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.updater;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.jar.installer.GitlabGetter;
import com.seibel.distanthorizons.core.jar.installer.ModrinthGetter;
import com.seibel.distanthorizons.core.jar.installer.WebDownloader;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.coreapi.util.jar.DeleteOnUnlock;
import distanthorizons.libraries.electronwill.nightconfig.core.Config;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.Logger;

public class SelfUpdater {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(SelfUpdater.class.getSimpleName());
    public static boolean deleteOldJarOnJvmShutdown = false;
    private static String currentJarSha = "";
    private static String mcVersion = SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion();
    public static File newFileLocation;

    public static boolean onStart() {
        LOGGER.info("Checking for DH update");
        try {
            currentJarSha = JarUtils.getFileChecksum(MessageDigest.getInstance("SHA"), JarUtils.jarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean returnValue = false;
        try {
            switch (Config.Client.Advanced.AutoUpdater.updateBranch.get()) {
                case STABLE: {
                    returnValue = SelfUpdater.onStableStart();
                    break;
                }
                case NIGHTLY: {
                    returnValue = SelfUpdater.onNightlyStart();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)e);
        }
        return returnValue;
    }

    public static boolean onStableStart() {
        if (!ModrinthGetter.init()) {
            return false;
        }
        if (!ModrinthGetter.mcVersions.contains(mcVersion)) {
            LOGGER.warn("Minecraft version [" + mcVersion + "] is not findable on Modrinth, only findable versions are [" + ModrinthGetter.mcVersions.toString() + "]");
            return false;
        }
        if (currentJarSha.equals(ModrinthGetter.getLatestShaForVersion(mcVersion))) {
            return false;
        }
        LOGGER.info("New version (" + ModrinthGetter.getLatestNameForVersion(mcVersion) + ") of " + "Distant Horizons" + " is available");
        newFileLocation = JarUtils.jarFile.getParentFile().toPath().resolve("update").resolve("DistantHorizons-" + ModrinthGetter.getLatestNameForVersion(mcVersion) + ".jar").toFile();
        if (Config.Client.Advanced.AutoUpdater.enableSilentUpdates.get().booleanValue()) {
            SelfUpdater.updateMod(mcVersion, newFileLocation);
            return false;
        }
        return true;
    }

    public static boolean onNightlyStart() {
        if (GitlabGetter.INSTANCE.projectPipelines.size() == 0) {
            return false;
        }
        Config pipeline = GitlabGetter.INSTANCE.projectPipelines.get(0);
        if (!pipeline.get("ref").equals(ModJarInfo.Git_Branch)) {
            return false;
        }
        if (!pipeline.get("status").equals("success")) {
            LOGGER.warn("Pipeline for branch [" + ModJarInfo.Git_Branch + "], pipeline ID [" + pipeline.get("id") + "], has either failed to build, or is still building.");
            return false;
        }
        if (!GitlabGetter.INSTANCE.getDownloads((Integer)pipeline.get("id")).containsKey(mcVersion)) {
            LOGGER.warn("Minecraft version [" + mcVersion + "] is not findable on Gitlab, findable versions are [" + GitlabGetter.INSTANCE.getDownloads((Integer)pipeline.get("id")).keySet().toArray().toString() + "].");
            return false;
        }
        String latestCommit = (String)pipeline.get("sha");
        if (ModJarInfo.Git_Commit.equals(latestCommit)) {
            return false;
        }
        LOGGER.info("New version (" + latestCommit + ") of " + "Distant Horizons" + " is available");
        newFileLocation = JarUtils.jarFile.getParentFile().toPath().resolve("update").resolve("DistantHorizons-" + latestCommit + ".jar").toFile();
        if (Config.Client.Advanced.AutoUpdater.enableSilentUpdates.get().booleanValue()) {
            SelfUpdater.updateMod(mcVersion, newFileLocation);
            return false;
        }
        return true;
    }

    public static boolean updateMod() {
        String mcVer = SingletonInjector.INSTANCE.get(IVersionConstants.class).getMinecraftVersion();
        return SelfUpdater.updateMod(mcVer, newFileLocation);
    }

    public static boolean updateMod(String minecraftVersion, File file) {
        boolean returnValue = false;
        switch (Config.Client.Advanced.AutoUpdater.updateBranch.get()) {
            case STABLE: {
                returnValue = SelfUpdater.updateStableMod(minecraftVersion, file);
                break;
            }
            case NIGHTLY: {
                returnValue = SelfUpdater.updateNightlyMod(minecraftVersion, file);
            }
        }
        return returnValue;
    }

    public static boolean updateStableMod(String minecraftVersion, File file) {
        try {
            LOGGER.info("Attempting to auto update Distant Horizons");
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            WebDownloader.downloadAsFile(ModrinthGetter.getLatestDownloadForVersion(minecraftVersion), file);
            if (!JarUtils.getFileChecksum(MessageDigest.getInstance("SHA"), file).equals(ModrinthGetter.getLatestShaForVersion(minecraftVersion))) {
                LOGGER.warn("DH update checksum failed, aborting install");
                throw new Exception("Checksum failed");
            }
            deleteOldJarOnJvmShutdown = true;
            LOGGER.info("Distant Horizons successfully updated. It will apply on game's relaunch");
            new Thread(() -> {
                System.setProperty("java.awt.headless", "false");
                JOptionPane.showMessageDialog(null, "Distant Horizons updated, this will be applied on game restart.", "Distant Horizons", 1);
            }).start();
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update Distant Horizons to version " + ModrinthGetter.getLatestNameForVersion(minecraftVersion));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean updateNightlyMod(String minecraftVersion, File file) {
        if (GitlabGetter.INSTANCE.projectPipelines.size() == 0) {
            return false;
        }
        try {
            LOGGER.info("Attempting to auto update Distant Horizons");
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            File mergedZip = file.getParentFile().toPath().resolve("merged.zip").toFile();
            WebDownloader.downloadAsFile(GitlabGetter.INSTANCE.getDownloads((Integer)GitlabGetter.INSTANCE.projectPipelines.get(0).get("id")).get(minecraftVersion), mergedZip);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(mergedZip));
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory() && zipEntry.getName().contains("Merged")) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] buffer = new byte[1024];
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                    deleteOldJarOnJvmShutdown = true;
                    LOGGER.info("Distant Horizons successfully updated. It will apply on game's relaunch");
                    new Thread(() -> {
                        System.setProperty("java.awt.headless", "false");
                        JOptionPane.showMessageDialog(null, "Distant Horizons updated, this will be applied on game restart.", "Distant Horizons", 1);
                    }).start();
                    zis.close();
                    Files.deleteIfExists(newFileLocation.getParentFile().toPath().resolve("merged.zip"));
                    return true;
                }
                zipEntry = zis.getNextEntry();
            }
            zis.close();
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to update Distant Horizons to version " + GitlabGetter.INSTANCE.projectPipelines.get(0).get("sha"));
            e.printStackTrace();
            return false;
        }
    }

    public static void onClose() {
        if (!deleteOldJarOnJvmShutdown) {
            return;
        }
        Path newJarPath = newFileLocation.toPath();
        Path finalJarPath = JarUtils.jarFile.getParentFile().toPath().resolve(newFileLocation.getName());
        try {
            Files.deleteIfExists(finalJarPath);
            Files.move(newJarPath, finalJarPath, new CopyOption[0]);
            Files.delete(newFileLocation.getParentFile().toPath());
        }
        catch (Exception e) {
            LOGGER.warn("Failed to move updated fire from [" + newFileLocation.getAbsolutePath() + "] to [" + JarUtils.jarFile.getParentFile().getAbsolutePath() + "], please move it manually", (Throwable)e);
        }
        try {
            String javaHome = System.getProperty("java.home");
            String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
            String execCommand = "\"" + javaBin + "\" -cp \"" + finalJarPath.toAbsolutePath() + "\" " + DeleteOnUnlock.class.getCanonicalName() + " " + URLEncoder.encode(JarUtils.jarFile.getAbsolutePath(), "UTF-8");
            Process deleteProcess = Runtime.getRuntime().exec(execCommand);
            if (deleteProcess.isAlive()) {
                LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " process started...");
            } else {
                LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " process failed to start.");
            }
            Thread.sleep(250L);
            if (deleteProcess.isAlive()) {
                LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " running, old jar file at [" + JarUtils.jarFile.getAbsolutePath() + "] should be deleted after Minecraft's JVM shutdown has completed.");
            } else {
                int processExitCode = deleteProcess.exitValue();
                if (processExitCode != DeleteOnUnlock.SUCCESS_EXIT_CODE) {
                    String failReason = processExitCode == DeleteOnUnlock.FAIL_EXIT_CODE ? "Timed out and was unable to delete the file." : "Ran into an unexpected error.";
                    LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " " + failReason);
                    LOGGER.error(DeleteOnUnlock.class.getSimpleName() + " Logs are listed below:");
                    String normalOutput = SelfUpdater.convertInputStreamToString(deleteProcess.getInputStream());
                    LOGGER.info("process output: \n\n" + normalOutput);
                    String errorOutput = SelfUpdater.convertInputStreamToString(deleteProcess.getInputStream());
                    LOGGER.error("process error output: \n\n" + errorOutput);
                } else {
                    LOGGER.info(DeleteOnUnlock.class.getSimpleName() + " completed before JVM shutdown.");
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete old jar using bootstrap method, doing backup 'Files.deleteOnExit()' method", (Throwable)e);
            JarUtils.jarFile.deleteOnExit();
            LOGGER.warn("If the old DH file didnt delete, delete it manually at [" + JarUtils.jarFile + "]");
        }
    }

    private static String convertInputStreamToString(InputStream inputStream) {
        try {
            byte[] bytes = new byte[inputStream.available()];
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            dataInputStream.readFully(bytes);
            return new String(bytes);
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

