/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.jar.gui;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.JarUtils;
import com.seibel.distanthorizons.core.wrapperInterfaces.config.ILangWrapper;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class BaseJFrame
extends JFrame {
    static final String LOOKANDFEEL = "GTK";

    public BaseJFrame() {
        this.init();
    }

    public BaseJFrame(boolean show, boolean resizable) {
        this.init();
        this.setVisible(show);
        this.setResizable(resizable);
    }

    public void init() {
        this.setTitle(SingletonInjector.INSTANCE.get(ILangWrapper.class).getLang("lod.title"));
        try {
            this.setIconImage(ImageIO.read(JarUtils.accessFile("icon.png")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(720, 480);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        BaseJFrame.initLookAndFeel();
    }

    public void addExtraButtons(int x, int y, boolean themeOnBottom, boolean rootPosOnLeft) {
        int langBoxHeight = 25;
        int langBoxWidth = 100;
        ArrayList<String> langsToChoose = new ArrayList<String>();
        try (InputStreamReader isr = new InputStreamReader(JarUtils.accessFile("assets/distanthorizons/lang"), StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            List<Object> col = Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(br.lines().toArray())));
            for (Object obj : col) {
                langsToChoose.add(((String)obj).replaceAll("\\.json", ""));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        JComboBox<Object> languageBox = new JComboBox<Object>(new DefaultComboBoxModel<Object>(langsToChoose.toArray()));
        languageBox.setSelectedIndex(langsToChoose.indexOf(Locale.getDefault().toString().toLowerCase()));
        languageBox.addActionListener(e -> Locale.setDefault(Locale.forLanguageTag(languageBox.getSelectedItem().toString())));
        languageBox.setBounds(rootPosOnLeft ? x : x - langBoxWidth, themeOnBottom ? y : y + langBoxHeight, langBoxWidth, langBoxHeight);
        this.add(languageBox);
    }

    public BaseJFrame addLogo() {
        final int logoHeight = 200;
        JPanel logo = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                try {
                    BufferedImage image = ImageIO.read(JarUtils.accessFile("logo.png"));
                    int logoWidth = (int)((double)logoHeight * ((double)image.getWidth() / (double)image.getHeight()));
                    g.drawImage(image, this.getWidth() / 2 - logoWidth / 2, 0, logoWidth, logoHeight, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        logo.setBounds(logo.getX(), logo.getY(), logo.getWidth(), logo.getHeight());
        this.add(logo);
        return this;
    }

    private static void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("System")) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            } else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if (LOOKANDFEEL.equals(LOOKANDFEEL)) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: GTK");
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:" + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }
            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel (" + lookAndFeel + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }
            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel (" + lookAndFeel + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }
}

