/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.ChunkSizedFullDataAccessor;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.apache.logging.log4j.Logger;

public class LodDataBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IBlockStateWrapper AIR = SingletonInjector.INSTANCE.get(IWrapperFactory.class).getAirBlockStateWrapper();
    private static boolean getTopErrorLogged = false;

    public static ChunkSizedFullDataAccessor createChunkData(IChunkWrapper chunkWrapper) {
        if (!LodDataBuilder.canGenerateLodFromChunk(chunkWrapper)) {
            return null;
        }
        ChunkSizedFullDataAccessor chunkData = new ChunkSizedFullDataAccessor(chunkWrapper.getChunkPos());
        int minBuildHeight = chunkWrapper.getMinFilledHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                LongArrayList longs = new LongArrayList(chunkWrapper.getHeight() / 4);
                int lastY = chunkWrapper.getMaxBuildHeight();
                IBiomeWrapper biome = chunkWrapper.getBiome(x, lastY, z);
                IBlockStateWrapper blockState = AIR;
                int mappedId = chunkData.getMapping().addIfNotPresentAndGetId(biome, blockState);
                byte light = (byte)((chunkWrapper.getBlockLight(x, lastY + 1, z) << 4) + chunkWrapper.getSkyLight(x, lastY + 1, z));
                int y = chunkWrapper.getLightBlockingHeightMapValue(x, z);
                IBlockStateWrapper topBlockState = chunkWrapper.getBlockState(x, y, z);
                while (!topBlockState.isAir() && y < chunkWrapper.getMaxBuildHeight()) {
                    try {
                        topBlockState = chunkWrapper.getBlockState(x, ++y, z);
                    }
                    catch (Exception e) {
                        if (!getTopErrorLogged) {
                            LOGGER.warn("Unexpected issue in LodDataBuilder, future errors won't be logged. Chunk [" + chunkWrapper.getChunkPos() + "] with max height: [" + chunkWrapper.getMaxBuildHeight() + "] had issue getting block at pos [" + x + "," + y + "," + z + "] error: " + e.getMessage(), (Throwable)e);
                            getTopErrorLogged = true;
                        }
                        --y;
                        break;
                    }
                }
                while (y >= minBuildHeight) {
                    IBiomeWrapper newBiome = chunkWrapper.getBiome(x, y, z);
                    IBlockStateWrapper newBlockState = chunkWrapper.getBlockState(x, y, z);
                    byte newLight = (byte)((chunkWrapper.getBlockLight(x, y + 1, z) << 4) + chunkWrapper.getSkyLight(x, y + 1, z));
                    if (!newBiome.equals(biome) || !newBlockState.equals(blockState)) {
                        longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getMinBuildHeight(), light));
                        biome = newBiome;
                        blockState = newBlockState;
                        mappedId = chunkData.getMapping().addIfNotPresentAndGetId(biome, blockState);
                        light = newLight;
                        lastY = y;
                    }
                    --y;
                }
                longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getMinBuildHeight(), light));
                chunkData.setSingleColumn(longs.toLongArray(), x, z);
            }
        }
        if (!LodDataBuilder.canGenerateLodFromChunk(chunkWrapper)) {
            return null;
        }
        LodUtil.assertTrue(chunkData.emptyCount() == 0L);
        return chunkData;
    }

    public static boolean canGenerateLodFromChunk(IChunkWrapper chunk) {
        return chunk != null && chunk.isLightCorrect();
    }
}

