/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding;

import com.seibel.distanthorizons.api.enums.config.EGpuUploadMethod;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.BufferMergeDirectionEnum;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.BufferQuad;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.AbstractRenderBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public class LodQuadBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final boolean skipQuadsWithZeroSkylight;
    public final short skyLightCullingBelow;
    private final ArrayList<BufferQuad>[] opaqueQuads = new ArrayList[6];
    private final ArrayList<BufferQuad>[] transparentQuads = new ArrayList[6];
    private final boolean doTransparency;
    public static final int[][][] DIRECTION_VERTEX_IBO_QUAD = new int[][][]{new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{0, 0}, {0, 1}, {1, 1}, {1, 0}}, new int[][]{{1, 0}, {1, 1}, {0, 1}, {0, 0}}, new int[][]{{0, 0}, {1, 0}, {1, 1}, {0, 1}}, new int[][]{{0, 1}, {1, 1}, {1, 0}, {0, 0}}};
    private int premergeCount = 0;

    public LodQuadBuilder(boolean enableSkylightCulling, short skyLightCullingBelow, boolean doTransparency) {
        this.doTransparency = doTransparency;
        for (int i = 0; i < 6; ++i) {
            this.opaqueQuads[i] = new ArrayList();
            this.transparentQuads[i] = new ArrayList();
        }
        this.skipQuadsWithZeroSkylight = enableSkylightCulling;
        this.skyLightCullingBelow = skyLightCullingBelow;
    }

    public void addQuadAdj(EDhDirection dir, short x, short y, short z, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte skyLight, byte blockLight) {
        ArrayList<BufferQuad> quadList;
        if (dir == EDhDirection.DOWN) {
            throw new IllegalArgumentException("addQuadAdj() is only for adj direction! Not UP or Down!");
        }
        if (this.skipQuadsWithZeroSkylight && skyLight == 0 && y + widthNorthSouthOrUpDown < this.skyLightCullingBelow) {
            return;
        }
        BufferQuad quad = new BufferQuad(x, y, z, widthEastWest, widthNorthSouthOrUpDown, color, skyLight, blockLight, dir);
        ArrayList<BufferQuad> arrayList = quadList = this.doTransparency && ColorUtil.getAlpha(color) < 255 ? this.transparentQuads[dir.ordinal()] : this.opaqueQuads[dir.ordinal()];
        if (!quadList.isEmpty() && (quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.EastWest) || quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.NorthSouthOrUpDown))) {
            ++this.premergeCount;
            return;
        }
        quadList.add(quad);
    }

    public void addQuadUp(short x, short maxY, short z, short widthEastWest, short widthNorthSouthOrUpDown, int color, byte skylight, byte blocklight) {
        ArrayList<BufferQuad> quadList;
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && maxY < this.skyLightCullingBelow) {
            return;
        }
        BufferQuad quad = new BufferQuad(x, maxY, z, widthEastWest, widthNorthSouthOrUpDown, color, skylight, blocklight, EDhDirection.UP);
        boolean isTransparent = this.doTransparency && ColorUtil.getAlpha(color) < 255;
        ArrayList<BufferQuad> arrayList = quadList = isTransparent ? this.transparentQuads[EDhDirection.UP.ordinal()] : this.opaqueQuads[EDhDirection.UP.ordinal()];
        if (!quadList.isEmpty() && (quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.EastWest) || quadList.get(quadList.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.NorthSouthOrUpDown))) {
            ++this.premergeCount;
            return;
        }
        quadList.add(quad);
    }

    public void addQuadDown(short x, short y, short z, short width, short wz, int color, byte skylight, byte blocklight) {
        ArrayList<BufferQuad> qs;
        if (this.skipQuadsWithZeroSkylight && skylight == 0 && y < this.skyLightCullingBelow) {
            return;
        }
        BufferQuad quad = new BufferQuad(x, y, z, width, wz, color, skylight, blocklight, EDhDirection.DOWN);
        ArrayList<BufferQuad> arrayList = qs = this.doTransparency && ColorUtil.getAlpha(color) < 255 ? this.transparentQuads[EDhDirection.DOWN.ordinal()] : this.opaqueQuads[EDhDirection.DOWN.ordinal()];
        if (!qs.isEmpty() && (qs.get(qs.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.EastWest) || qs.get(qs.size() - 1).tryMerge(quad, BufferMergeDirectionEnum.NorthSouthOrUpDown))) {
            ++this.premergeCount;
            return;
        }
        qs.add(quad);
    }

    private void putQuad(ByteBuffer bb, BufferQuad quad) {
        int[][] quadBase = DIRECTION_VERTEX_IBO_QUAD[quad.direction.ordinal()];
        short widthEastWest = quad.widthEastWest;
        short widthNorthSouth = quad.widthNorthSouthOrUpDown;
        EDhDirection.Axis axis = quad.direction.getAxis();
        for (int i = 0; i < quadBase.length; ++i) {
            int mz;
            int my;
            int mx;
            short dz;
            short dy;
            short dx;
            switch (axis) {
                case X: {
                    dx = 0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    mx = 0;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = quadBase[i][0] == 1 ? 1 : -1;
                    break;
                }
                case Y: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = 0;
                    dz = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = 0;
                    mz = quadBase[i][1] == 1 ? 1 : -1;
                    break;
                }
                case Z: {
                    dx = quadBase[i][0] == 1 ? widthEastWest : (short)0;
                    dy = quadBase[i][1] == 1 ? widthNorthSouth : (short)0;
                    dz = 0;
                    mx = quadBase[i][0] == 1 ? 1 : -1;
                    my = quadBase[i][1] == 1 ? 1 : -1;
                    mz = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid Axis enum: " + axis);
                }
            }
            this.putVertex(bb, (short)(quad.x + dx), (short)(quad.y + dy), (short)(quad.z + dz), quad.hasError ? ColorUtil.RED : quad.color, quad.hasError ? (byte)15 : (byte)quad.skyLight, quad.hasError ? (byte)15 : (byte)quad.blockLight, mx, my, mz);
        }
    }

    private void putVertex(ByteBuffer bb, short x, short y, short z, int color, byte skylight, byte blocklight, int mx, int my, int mz) {
        skylight = (byte)(skylight % 16);
        blocklight = (byte)(blocklight % 16);
        bb.putShort(x);
        bb.putShort(y);
        bb.putShort(z);
        short meta = 0;
        meta = (short)(meta | (skylight | blocklight << 4));
        int mirco = 0;
        if (mx != 0) {
            mirco = (byte)(mirco | (mx > 0 ? 1 : 3));
        }
        if (my != 0) {
            mirco = (byte)(mirco | (my > 0 ? 4 : 12));
        }
        if (mz != 0) {
            mirco = (byte)(mirco | (mz > 0 ? 16 : 48));
        }
        meta = (short)(meta | mirco << 8);
        bb.putShort(meta);
        byte r = (byte)ColorUtil.getRed(color);
        byte g = (byte)ColorUtil.getGreen(color);
        byte b = (byte)ColorUtil.getBlue(color);
        byte a = this.doTransparency ? (byte)ColorUtil.getAlpha(color) : (byte)-1;
        bb.put(r);
        bb.put(g);
        bb.put(b);
        bb.put(a);
    }

    public void finalizeData() {
        this.mergeQuads();
    }

    public void mergeQuads() {
        long mergeCount = 0L;
        long preQuadsCount = this.getCurrentOpaqueQuadsCount() + this.getCurrentTransparentQuadsCount();
        if (preQuadsCount <= 1L) {
            return;
        }
        for (int directionIndex = 0; directionIndex < 6; ++directionIndex) {
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.opaqueQuads, directionIndex, BufferMergeDirectionEnum.EastWest);
            if (this.doTransparency) {
                mergeCount += LodQuadBuilder.mergeQuadsInternal(this.transparentQuads, directionIndex, BufferMergeDirectionEnum.EastWest);
            }
            if (directionIndex != EDhDirection.UP.ordinal() && directionIndex != EDhDirection.DOWN.ordinal()) continue;
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.opaqueQuads, directionIndex, BufferMergeDirectionEnum.NorthSouthOrUpDown);
            if (!this.doTransparency) continue;
            mergeCount += LodQuadBuilder.mergeQuadsInternal(this.transparentQuads, directionIndex, BufferMergeDirectionEnum.NorthSouthOrUpDown);
        }
        long postQuadsCount = this.getCurrentOpaqueQuadsCount() + this.getCurrentTransparentQuadsCount();
        LOGGER.debug("Merged " + mergeCount + "/" + preQuadsCount + "(" + (double)mergeCount / (double)preQuadsCount + ") quads");
    }

    private static long mergeQuadsInternal(ArrayList<BufferQuad>[] list, int directionIndex, BufferMergeDirectionEnum mergeDirection) {
        if (list[directionIndex].size() <= 1) {
            return 0L;
        }
        list[directionIndex].sort((objOne, objTwo) -> objOne.compare((BufferQuad)objTwo, mergeDirection));
        long mergeCount = 0L;
        ListIterator<BufferQuad> iter = list[directionIndex].listIterator();
        BufferQuad currentQuad = iter.next();
        while (iter.hasNext()) {
            BufferQuad nextQuad = iter.next();
            if (currentQuad.tryMerge(nextQuad, mergeDirection)) {
                ++mergeCount;
                iter.set(null);
                continue;
            }
            currentQuad = nextQuad;
        }
        list[directionIndex].removeIf(Objects::isNull);
        return mergeCount;
    }

    public Iterator<ByteBuffer> makeOpaqueVertexBuffers() {
        return new Iterator<ByteBuffer>(){
            final ByteBuffer bb = ByteBuffer.allocateDirect(AbstractRenderBuffer.FULL_SIZED_BUFFER).order(ByteOrder.nativeOrder());
            int dir = this.skipEmpty(0);
            int quad = 0;

            private int skipEmpty(int d) {
                while (d < 6 && LodQuadBuilder.this.opaqueQuads[d].isEmpty()) {
                    ++d;
                }
                return d;
            }

            @Override
            public boolean hasNext() {
                return this.dir < 6;
            }

            @Override
            public ByteBuffer next() {
                if (this.dir >= 6) {
                    return null;
                }
                this.bb.clear();
                this.bb.limit(AbstractRenderBuffer.FULL_SIZED_BUFFER);
                while (this.bb.hasRemaining() && this.dir < 6) {
                    this.writeData();
                }
                this.bb.limit(this.bb.position());
                this.bb.rewind();
                return this.bb;
            }

            private void writeData() {
                int i;
                for (i = this.quad; i < LodQuadBuilder.this.opaqueQuads[this.dir].size() && this.bb.hasRemaining(); ++i) {
                    LodQuadBuilder.this.putQuad(this.bb, (BufferQuad)LodQuadBuilder.this.opaqueQuads[this.dir].get(i));
                }
                if (i >= LodQuadBuilder.this.opaqueQuads[this.dir].size()) {
                    this.quad = 0;
                    ++this.dir;
                    this.dir = this.skipEmpty(this.dir);
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public Iterator<ByteBuffer> makeTransparentVertexBuffers() {
        return new Iterator<ByteBuffer>(){
            final ByteBuffer bb = ByteBuffer.allocateDirect(AbstractRenderBuffer.FULL_SIZED_BUFFER).order(ByteOrder.nativeOrder());
            int directionIndex = this.skipEmptyDirectionIndices(0);
            int quad = 0;

            private int skipEmptyDirectionIndices(int directionIndex) {
                while (directionIndex < 6 && (LodQuadBuilder.this.transparentQuads[directionIndex] == null || LodQuadBuilder.this.transparentQuads[directionIndex].isEmpty())) {
                    ++directionIndex;
                }
                return directionIndex;
            }

            @Override
            public boolean hasNext() {
                return this.directionIndex < 6;
            }

            @Override
            public ByteBuffer next() {
                if (this.directionIndex >= 6) {
                    return null;
                }
                this.bb.clear();
                this.bb.limit(AbstractRenderBuffer.FULL_SIZED_BUFFER);
                while (this.bb.hasRemaining() && this.directionIndex < 6) {
                    this.writeData();
                }
                this.bb.limit(this.bb.position());
                this.bb.rewind();
                return this.bb;
            }

            private void writeData() {
                int i;
                for (i = this.quad; i < LodQuadBuilder.this.transparentQuads[this.directionIndex].size() && this.bb.hasRemaining(); ++i) {
                    LodQuadBuilder.this.putQuad(this.bb, (BufferQuad)LodQuadBuilder.this.transparentQuads[this.directionIndex].get(i));
                }
                if (i >= LodQuadBuilder.this.transparentQuads[this.directionIndex].size()) {
                    this.quad = 0;
                    ++this.directionIndex;
                    this.directionIndex = this.skipEmptyDirectionIndices(this.directionIndex);
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public BufferFiller makeOpaqueBufferFiller(final EGpuUploadMethod method) {
        return new BufferFiller(){
            int dir = 0;
            int quad = 0;

            @Override
            public boolean fill(GLVertexBuffer vbo) {
                if (this.dir >= 6) {
                    vbo.setVertexCount(0);
                    return false;
                }
                int numOfQuads = this._countRemainingQuads();
                if (numOfQuads > AbstractRenderBuffer.MAX_QUADS_PER_BUFFER) {
                    numOfQuads = AbstractRenderBuffer.MAX_QUADS_PER_BUFFER;
                }
                if (numOfQuads == 0) {
                    vbo.setVertexCount(0);
                    return false;
                }
                ByteBuffer bb = vbo.mapBuffer(numOfQuads * AbstractRenderBuffer.QUADS_BYTE_SIZE, method, AbstractRenderBuffer.FULL_SIZED_BUFFER);
                if (bb == null) {
                    throw new NullPointerException("mapBuffer returned null");
                }
                bb.clear();
                bb.limit(numOfQuads * AbstractRenderBuffer.QUADS_BYTE_SIZE);
                while (bb.hasRemaining() && this.dir < 6) {
                    this.writeData(bb);
                }
                bb.rewind();
                vbo.unmapBuffer();
                vbo.setVertexCount(numOfQuads * 4);
                return this.dir < 6;
            }

            private int _countRemainingQuads() {
                int a = LodQuadBuilder.this.opaqueQuads[this.dir].size() - this.quad;
                for (int i = this.dir + 1; i < LodQuadBuilder.this.opaqueQuads.length; ++i) {
                    a += LodQuadBuilder.this.opaqueQuads[i].size();
                }
                return a;
            }

            private void writeData(ByteBuffer bb) {
                int startQ;
                int i = startQ = this.quad;
                for (i = startQ; i < LodQuadBuilder.this.opaqueQuads[this.dir].size() && bb.hasRemaining(); ++i) {
                    LodQuadBuilder.this.putQuad(bb, (BufferQuad)LodQuadBuilder.this.opaqueQuads[this.dir].get(i));
                }
                if (i >= LodQuadBuilder.this.opaqueQuads[this.dir].size()) {
                    this.quad = 0;
                    ++this.dir;
                    while (this.dir < 6 && LodQuadBuilder.this.opaqueQuads[this.dir].isEmpty()) {
                        ++this.dir;
                    }
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public BufferFiller makeTransparentBufferFiller(final EGpuUploadMethod method) {
        return new BufferFiller(){
            int dir = 0;
            int quad = 0;

            @Override
            public boolean fill(GLVertexBuffer vbo) {
                if (this.dir >= 6) {
                    vbo.setVertexCount(0);
                    return false;
                }
                int numOfQuads = this._countRemainingQuads();
                if (numOfQuads > AbstractRenderBuffer.MAX_QUADS_PER_BUFFER) {
                    numOfQuads = AbstractRenderBuffer.MAX_QUADS_PER_BUFFER;
                }
                if (numOfQuads == 0) {
                    vbo.setVertexCount(0);
                    return false;
                }
                ByteBuffer bb = vbo.mapBuffer(numOfQuads * AbstractRenderBuffer.QUADS_BYTE_SIZE, method, AbstractRenderBuffer.FULL_SIZED_BUFFER);
                if (bb == null) {
                    throw new NullPointerException("mapBuffer returned null");
                }
                bb.clear();
                bb.limit(numOfQuads * AbstractRenderBuffer.QUADS_BYTE_SIZE);
                while (bb.hasRemaining() && this.dir < 6) {
                    this.writeData(bb);
                }
                bb.rewind();
                vbo.unmapBuffer();
                vbo.setVertexCount(numOfQuads * 4);
                return this.dir < 6;
            }

            private int _countRemainingQuads() {
                int a = LodQuadBuilder.this.transparentQuads[this.dir].size() - this.quad;
                for (int i = this.dir + 1; i < LodQuadBuilder.this.transparentQuads.length; ++i) {
                    a += LodQuadBuilder.this.transparentQuads[i].size();
                }
                return a;
            }

            private void writeData(ByteBuffer bb) {
                int startQ;
                int i = startQ = this.quad;
                for (i = startQ; i < LodQuadBuilder.this.transparentQuads[this.dir].size() && bb.hasRemaining(); ++i) {
                    LodQuadBuilder.this.putQuad(bb, (BufferQuad)LodQuadBuilder.this.transparentQuads[this.dir].get(i));
                }
                if (i >= LodQuadBuilder.this.transparentQuads[this.dir].size()) {
                    this.quad = 0;
                    ++this.dir;
                    while (this.dir < 6 && LodQuadBuilder.this.transparentQuads[this.dir].isEmpty()) {
                        ++this.dir;
                    }
                } else {
                    this.quad = i;
                }
            }
        };
    }

    public int getCurrentOpaqueQuadsCount() {
        int i = 0;
        for (ArrayList<BufferQuad> quadList : this.opaqueQuads) {
            i += quadList.size();
        }
        return i;
    }

    public int getCurrentTransparentQuadsCount() {
        if (!this.doTransparency) {
            return 0;
        }
        int i = 0;
        for (ArrayList<BufferQuad> quadList : this.transparentQuads) {
            i += quadList.size();
        }
        return i;
    }

    public int getCurrentNeededOpaqueVertexBufferCount() {
        return MathUtil.ceilDiv(this.getCurrentOpaqueQuadsCount(), AbstractRenderBuffer.MAX_QUADS_PER_BUFFER);
    }

    public int getCurrentNeededTransparentVertexBufferCount() {
        if (!this.doTransparency) {
            return 0;
        }
        return MathUtil.ceilDiv(this.getCurrentTransparentQuadsCount(), AbstractRenderBuffer.MAX_QUADS_PER_BUFFER);
    }

    public static interface BufferFiller {
        public boolean fill(GLVertexBuffer var1);
    }
}

