/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData.accessor;

import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.accessor.FullDataArrayAccessor;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;

public class ChunkSizedFullDataAccessor
extends FullDataArrayAccessor {
    public final DhChunkPos chunkPos;
    public final DhSectionPos sectionPos;
    public final byte detailLevel = 0;

    public ChunkSizedFullDataAccessor(DhChunkPos chunkPos) {
        super(new FullDataPointIdMap(new DhSectionPos(chunkPos)), new long[256][0], 16);
        this.chunkPos = chunkPos;
        this.sectionPos = new DhSectionPos(4, this.chunkPos.x, this.chunkPos.z);
    }

    public void setSingleColumn(long[] data, int xRelative, int zRelative) {
        this.dataArrays[xRelative * 16 + zRelative] = data;
    }

    public long nonEmptyCount() {
        long count = 0L;
        for (long[] data : this.dataArrays) {
            if (data.length == 0) continue;
            ++count;
        }
        return count;
    }

    public long emptyCount() {
        return 256L - this.nonEmptyCount();
    }

    public DhSectionPos getSectionPos() {
        return this.sectionPos;
    }

    public String toString() {
        return this.chunkPos + " " + this.nonEmptyCount();
    }
}

