/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.fullData;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FullDataPointIdMap {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean RUN_SERIALIZATION_DUPLICATE_VALIDATION = false;
    private static final String BLOCK_STATE_SEPARATOR_STRING = "_DH-BSW_";
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private DhSectionPos pos;
    private final ArrayList<Entry> entryList = new ArrayList();
    private final HashMap<Entry, Integer> idMap = new HashMap();

    public FullDataPointIdMap(DhSectionPos pos) {
        this.pos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry getEntry(int id) throws IndexOutOfBoundsException {
        try {
            Entry entry;
            this.readWriteLock.readLock().lock();
            try {
                entry = this.entryList.get(id);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("FullData ID Map out of sync for pos: " + this.pos + ". ID: [" + id + "] greater than the number of known ID's: [" + this.entryList.size() + "].");
            }
            Entry entry2 = entry;
            return entry2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public IBiomeWrapper getBiomeWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).biome;
    }

    public IBlockStateWrapper getBlockStateWrapper(int id) throws IndexOutOfBoundsException {
        return this.getEntry((int)id).blockState;
    }

    public int getMaxValidId() {
        return this.entryList.size() - 1;
    }

    public DhSectionPos getPos() {
        return this.pos;
    }

    public int addIfNotPresentAndGetId(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.addIfNotPresentAndGetId(new Entry(biome, blockState), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addIfNotPresentAndGetId(Entry biomeBlockStateEntry, boolean useWriteLocks) {
        try {
            int id;
            if (useWriteLocks) {
                this.readWriteLock.writeLock().lock();
            }
            if (this.idMap.containsKey(biomeBlockStateEntry)) {
                id = this.idMap.get(biomeBlockStateEntry);
            } else {
                id = this.entryList.size();
                this.entryList.add(biomeBlockStateEntry);
                this.idMap.put(biomeBlockStateEntry, id);
            }
            int n = id;
            return n;
        }
        finally {
            if (useWriteLocks) {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] mergeAndReturnRemappedEntityIds(FullDataPointIdMap target) {
        try {
            LOGGER.trace("merging {" + this.pos + ", " + this.entryList.size() + "} and {" + target.pos + ", " + target.entryList.size() + "}");
            target.readWriteLock.readLock().lock();
            this.readWriteLock.writeLock().lock();
            ArrayList<Entry> entriesToMerge = target.entryList;
            int[] remappedEntryIds = new int[entriesToMerge.size()];
            for (int i = 0; i < entriesToMerge.size(); ++i) {
                int id;
                Entry entity = entriesToMerge.get(i);
                remappedEntryIds[i] = id = this.addIfNotPresentAndGetId(entity, false);
            }
            int[] nArray = remappedEntryIds;
            return nArray;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
            target.readWriteLock.readLock().unlock();
            LOGGER.trace("finished merging {" + this.pos + ", " + this.entryList.size() + "} and {" + target.pos + ", " + target.entryList.size() + "}");
        }
    }

    public void clear(DhSectionPos pos) {
        this.pos = pos;
        this.entryList.clear();
        this.idMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(DhDataOutputStream outputStream) throws IOException {
        try {
            this.readWriteLock.readLock().lock();
            outputStream.writeInt(this.entryList.size());
            HashMap dataPointEntryBySerialization = new HashMap();
            for (Entry entry : this.entryList) {
                String entryString = entry.serialize();
                outputStream.writeUTF(entryString);
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
            LOGGER.trace("serialize " + this.pos + " " + this.entryList.size());
        }
    }

    public static FullDataPointIdMap deserialize(DhDataInputStream inputStream, DhSectionPos pos, ILevelWrapper levelWrapper) throws IOException, InterruptedException {
        int entityCount = inputStream.readInt();
        HashMap dataPointEntryBySerialization = new HashMap();
        FullDataPointIdMap newMap = new FullDataPointIdMap(pos);
        for (int i = 0; i < entityCount; ++i) {
            String entryString = inputStream.readUTF();
            Entry newEntry = Entry.deserialize(entryString, levelWrapper);
            newMap.entryList.add(newEntry);
        }
        LOGGER.trace("deserialized " + pos + " " + newMap.entryList.size() + "-" + entityCount);
        return newMap;
    }

    public boolean equals(Object other) {
        return other == this;
    }

    private static final class Entry {
        private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        public final IBiomeWrapper biome;
        public final IBlockStateWrapper blockState;
        private Integer hashCode = null;

        public Entry(IBiomeWrapper biome, IBlockStateWrapper blockState) {
            this.biome = biome;
            this.blockState = blockState;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = this.serialize().hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == this) {
                return true;
            }
            if (!(otherObj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)otherObj;
            return other.biome.getSerialString().equals(this.biome.getSerialString()) && other.blockState.getSerialString().equals(this.blockState.getSerialString());
        }

        public String toString() {
            return this.serialize();
        }

        public String serialize() {
            return this.biome.getSerialString() + FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING + this.blockState.getSerialString();
        }

        public static Entry deserialize(String str, ILevelWrapper levelWrapper) throws IOException, InterruptedException {
            String[] stringArray = str.split(FullDataPointIdMap.BLOCK_STATE_SEPARATOR_STRING);
            if (stringArray.length != 2) {
                throw new IOException("Failed to deserialize BiomeBlockStateEntry");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException(FullDataPointIdMap.class.getSimpleName() + " task interrupted.");
            }
            IBiomeWrapper biome = WRAPPER_FACTORY.deserializeBiomeWrapper(stringArray[0], levelWrapper);
            IBlockStateWrapper blockState = WRAPPER_FACTORY.deserializeBlockStateWrapper(stringArray[1], levelWrapper);
            return new Entry(biome, blockState);
        }
    }
}

