/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.config.EBlocksToAvoid;
import com.seibel.distanthorizons.api.enums.config.ELodShading;
import com.seibel.distanthorizons.api.enums.config.EMaxHorizontalResolution;
import com.seibel.distanthorizons.api.enums.config.EVerticalQuality;
import com.seibel.distanthorizons.api.enums.rendering.ETransparency;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import java.util.Timer;
import java.util.TimerTask;

public class RenderCacheConfigEventHandler {
    private static RenderCacheConfigEventHandler INSTANCE;
    private final ConfigChangeListener<EMaxHorizontalResolution> horizontalResolutionChangeListener = new ConfigChangeListener<EMaxHorizontalResolution>(Config.Client.Advanced.Graphics.Quality.maxHorizontalResolution, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EVerticalQuality> verticalQualityChangeListener = new ConfigChangeListener<EVerticalQuality>(Config.Client.Advanced.Graphics.Quality.verticalQuality, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<ETransparency> transparencyChangeListener = new ConfigChangeListener<ETransparency>(Config.Client.Advanced.Graphics.Quality.transparency, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<EBlocksToAvoid> blocksToIgnoreChangeListener = new ConfigChangeListener<EBlocksToAvoid>(Config.Client.Advanced.Graphics.Quality.blocksToIgnore, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Boolean> tintWithAvoidedBlocksChangeListener = new ConfigChangeListener<Boolean>(Config.Client.Advanced.Graphics.Quality.tintWithAvoidedBlocks, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Double> brightnessMultiplierChangeListener = new ConfigChangeListener<Double>(Config.Client.Advanced.Graphics.AdvancedGraphics.brightnessMultiplier, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<Double> saturationMultiplierChangeListener = new ConfigChangeListener<Double>(Config.Client.Advanced.Graphics.AdvancedGraphics.saturationMultiplier, newValue -> this.refreshRenderDataAfterTimeout());
    private final ConfigChangeListener<ELodShading> lodShadingChangeListener = new ConfigChangeListener<ELodShading>(Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading, newValue -> this.refreshRenderDataAfterTimeout());
    private static final long TIMEOUT_IN_MS = 4000L;
    private Timer cacheClearingTimer;

    public static RenderCacheConfigEventHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RenderCacheConfigEventHandler();
        }
        return INSTANCE;
    }

    private RenderCacheConfigEventHandler() {
    }

    private void refreshRenderDataAfterTimeout() {
        if (this.cacheClearingTimer != null) {
            this.cacheClearingTimer.cancel();
        }
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                DhApi.Delayed.renderProxy.clearRenderDataCache();
            }
        };
        this.cacheClearingTimer = new Timer("RenderCacheConfig-Timeout-Timer");
        this.cacheClearingTimer.schedule(timerTask, 4000L);
    }
}

