/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.DarkConfig;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.buuz135.darkmodeeverywhere.DarkShaderInstance;
import com.buuz135.darkmodeeverywhere.RegisterShaderCallback;
import com.buuz135.darkmodeeverywhere.RenderedClassesTracker;
import com.buuz135.darkmodeeverywhere.ShaderConfig;
import com.mojang.datafixers.util.Pair;
import io.github.fabricators_of_create.porting_lib.config.ConfigEvents;
import io.github.fabricators_of_create.porting_lib.config.ModConfig;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_7919;

public class ClientProxy
implements ClientModInitializer {
    private final EventExecutor eventExecutor = new DefaultEventExecutor();
    public static Object2BooleanMap<String> BLACKLISTED_ELEMENTS = new Object2BooleanOpenHashMap();
    public static List<String> MODDED_BLACKLIST = new ArrayList<String>();
    public static ShaderConfig CONFIG = new ShaderConfig();
    public static Map<ShaderConfig.ShaderValue, class_5944> TEX_SHADERS = new HashMap<ShaderConfig.ShaderValue, class_5944>();
    public static Map<ShaderConfig.ShaderValue, class_5944> TEX_COLOR_SHADERS = new HashMap<ShaderConfig.ShaderValue, class_5944>();
    private static HashMap<class_2960, Promise<class_5944>> ON_SHADERS_LOADED = new HashMap();
    public static List<ShaderConfig.ShaderValue> SHADER_VALUES = new ArrayList<ShaderConfig.ShaderValue>();
    public static ShaderConfig.ShaderValue SELECTED_SHADER_VALUE = null;

    public void onInitializeClient() {
        ShaderConfig.load();
        RegisterShaderCallback.EVENT.register(this::registerAllShaders);
        ConfigEvents.RELOADING.register(this::onConfigReload);
        ScreenEvents.AFTER_INIT.register(this::openGui);
    }

    private void registerShaderForLoading(class_5912 resourceProvider, List<Pair<class_5944, Consumer<class_5944>>> shaderList, class_2960 shaderResourceLocation, class_293 format) {
        try {
            DarkModeEverywhere.LOGGER.debug("Registering shader {} for loading", (Object)shaderResourceLocation);
            ON_SHADERS_LOADED.put(shaderResourceLocation, (Promise<class_5944>)this.eventExecutor.newPromise());
            shaderList.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)((Object)new DarkShaderInstance(resourceProvider, shaderResourceLocation, format)), shaderInstance -> {
                DarkModeEverywhere.LOGGER.debug("Shader {} has loaded, resolving promise", (Object)shaderResourceLocation);
                ON_SHADERS_LOADED.get(shaderResourceLocation).setSuccess(shaderInstance);
            }));
        }
        catch (IOException e) {
            DarkModeEverywhere.LOGGER.trace("Failed to register shader", (Throwable)e);
        }
    }

    public void listenForShaderLoaded(class_5912 resourceProvider, List<Pair<class_5944, Consumer<class_5944>>> shaderList, class_2960 shaderResourceLocation, class_293 format, Consumer<class_5944> onLoaded) {
        if (!ON_SHADERS_LOADED.containsKey(shaderResourceLocation)) {
            this.registerShaderForLoading(resourceProvider, shaderList, shaderResourceLocation, format);
        }
        Promise<class_5944> onLoadedPromise = ON_SHADERS_LOADED.get(shaderResourceLocation);
        FutureListener listener = shaderInstance -> onLoaded.accept((class_5944)shaderInstance.get());
        onLoadedPromise.addListener((GenericFutureListener)listener);
    }

    public void registerAllShaders(class_5912 resourceProvider, List<Pair<class_5944, Consumer<class_5944>>> shaderList) {
        TEX_SHADERS = new HashMap<ShaderConfig.ShaderValue, class_5944>();
        TEX_COLOR_SHADERS = new HashMap<ShaderConfig.ShaderValue, class_5944>();
        ON_SHADERS_LOADED = new HashMap();
        SHADER_VALUES = new ArrayList<ShaderConfig.ShaderValue>();
        for (ShaderConfig.ShaderValue shaderValue : CONFIG.getShaders()) {
            SHADER_VALUES.add(shaderValue);
            if (shaderValue == null) continue;
            this.listenForShaderLoaded(resourceProvider, shaderList, shaderValue.texShaderLocation, class_290.field_1585, shaderInstance -> TEX_SHADERS.put(shaderValue, (class_5944)shaderInstance));
            this.listenForShaderLoaded(resourceProvider, shaderList, shaderValue.texColorShaderLocation, class_290.field_1575, shaderInstance -> TEX_COLOR_SHADERS.put(shaderValue, (class_5944)shaderInstance));
        }
        SELECTED_SHADER_VALUE = SHADER_VALUES.get(CONFIG.getSelectedShaderIndex());
        RenderedClassesTracker.start();
    }

    public static class_5944 getSelectedTexShader() {
        return TEX_SHADERS.get(SELECTED_SHADER_VALUE);
    }

    public static class_5944 getSelectedTexColorShader() {
        return TEX_COLOR_SHADERS.get(SELECTED_SHADER_VALUE);
    }

    public static ShaderConfig.ShaderValue getSelectedShaderValue() {
        return SELECTED_SHADER_VALUE;
    }

    public void onConfigReload(ModConfig config) {
        BLACKLISTED_ELEMENTS.clear();
    }

    private static boolean blacklistContains(List<String> blacklist, String elementName) {
        return blacklist.stream().anyMatch(elementName::contains);
    }

    public static boolean isElementNameBlacklisted(String elementName) {
        return BLACKLISTED_ELEMENTS.computeIfAbsent((Object)elementName, name -> {
            DarkModeEverywhere.LOGGER.debug("Considering {} for element blacklist", name);
            RenderedClassesTracker.add(name);
            return ClientProxy.blacklistContains(MODDED_BLACKLIST, name) || ClientProxy.blacklistContains((List)DarkConfig.CLIENT.METHOD_SHADER_BLACKLIST.get(), name);
        });
    }

    private int getNextShaderValueIndex() {
        if (class_437.method_25442()) {
            return 0;
        }
        int nextShaderIndex = SHADER_VALUES.indexOf(SELECTED_SHADER_VALUE) + 1;
        if (nextShaderIndex >= SHADER_VALUES.size()) {
            return 0;
        }
        return nextShaderIndex;
    }

    private class_7919 getShaderSwitchButtonTooltip() {
        class_5250 tooltipComponent = (SELECTED_SHADER_VALUE == null ? class_2561.method_43471((String)"gui.darkmodeeverywhere.light_mode") : ClientProxy.SELECTED_SHADER_VALUE.displayName).method_27662();
        tooltipComponent.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        tooltipComponent.method_10852((class_2561)class_2561.method_43471((String)"gui.tooltip.darkmodeeverywhere.shader_switch_tooltip").method_27692(class_124.field_1080));
        return class_7919.method_47407((class_2561)tooltipComponent);
    }

    public void openGui(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        if (screen instanceof class_465 || ((Boolean)DarkConfig.CLIENT.SHOW_BUTTON_IN_TITLE_SCREEN.get()).booleanValue() && screen instanceof class_442) {
            int x = (Integer)DarkConfig.CLIENT.GUI_BUTTON_X_OFFSET.get();
            int y = (Integer)DarkConfig.CLIENT.GUI_BUTTON_Y_OFFSET.get();
            if (screen instanceof class_442) {
                x = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_X_OFFSET.get();
                y = (Integer)DarkConfig.CLIENT.TITLE_SCREEN_BUTTON_Y_OFFSET.get();
            }
            class_4185.class_7840 buttonBuilder = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.darkmodeeverywhere.dark_mode"), button -> {
                int selectedShaderIndex = this.getNextShaderValueIndex();
                CONFIG.setSelectedShaderIndex(selectedShaderIndex);
                SELECTED_SHADER_VALUE = SHADER_VALUES.get(selectedShaderIndex);
                button.method_47400(this.getShaderSwitchButtonTooltip());
            });
            buttonBuilder.method_46433(x, screen.field_22790 - 24 - y);
            buttonBuilder.method_46437(60, 20);
            buttonBuilder.method_46436(this.getShaderSwitchButtonTooltip());
            class_4185 button2 = buttonBuilder.method_46431();
            Screens.getButtons((class_437)screen).add(button2);
        }
    }
}

